///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK SelectDBDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND DBListBox_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        SelectDBDialog_hWnd = xHandle;

        SendMessage(SelectDBDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Select Database");
        SendMessage(SelectDBDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        DBListBox_hWnd = GetDlgItem(SelectDBDialog_hWnd, 1000);

        //-------------------------------------------------------------------------

        SPWD.Cancel = FALSE;

        while(TRUE)
        {
            if(SPWD.Cancel == FALSE && LoadDBListBox(DBListBox_hWnd) == FALSE)
            {
                DialogBox(MainInstance, MAKEINTRESOURCE(110), SelectDBDialog_hWnd, SQLPWDDialog);
            }
            else break;
        }

        if(SPWD.Cancel == TRUE)
        {
            EndDialog(SelectDBDialog_hWnd,0);
            DestroyWindow(SelectDBDialog_hWnd);
        }

        //-------------------------------------------------------------------------

        CenterWindow(SelectDBDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            int Item = CurrentListBoxItem(DBListBox_hWnd);

            if(Item < 0)
                return 0;

            char Buffer[256];

            ListBoxItemTextEx(DBListBox_hWnd, Item, Buffer);

            Set_Text(JID.Database_hWnd, Buffer);

            EndDialog(SelectDBDialog_hWnd,0);
            DestroyWindow(SelectDBDialog_hWnd);

            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            EndDialog(SelectDBDialog_hWnd,0);
            DestroyWindow(SelectDBDialog_hWnd);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(SelectDBDialog_hWnd,0);
        DestroyWindow(SelectDBDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

